/* File: HurdleJumpingKarel.java
 * 
 * A program in which Karel jumps over eight hurdles.
 */

import stanford.karel.*;

public class HurdleJumpingKarel extends SuperKarel {
	public void run() {
		for (int i = 0; i < 8; i++) {
			if (frontIsClear()) {
				move();
			} else {
				jumpHurdle();
			}
		}
	}
	
	/* Precondition:  Karel is standing in front of a hurdle
	 *                and is facing East.
	 * Postcondition: Karel is on the other side of the hurdle at ground level.
	 */
	private void jumpHurdle() {
		climbHurdle();
		move();
		descendHurdle();
	}
	
	/* Precondition:  Karel is standing in front of a hurdle, facing East.
	 * Postcondition: Karel is at the top of the hurdle facing East.
	 */
	private void climbHurdle() {
		turnLeft();
		while (rightIsBlocked()) {
			move();
		}
		turnRight();
	}
	
	/* Precondition:  Karel is standing at the top of a hurdle, facing East.
	 * Postcondition: Karel is standing at the bottom of the hurdle, facing East.
	 */
	private void descendHurdle() {
		turnRight();
		while (frontIsClear()) {
			move();
		}
		turnLeft();
	}
}
